
enum Errors: String, Error {
   case OutOfStock = "Hello"
}
struct Stock {
   var totalLamps = 5
   mutating func sold(amount: Int) throws {
      if amount > totalLamps {
         throw Errors.OutOfStock
      } else {
         totalLamps = totalLamps - amount
      }
   }
}
var mystock = Stock()

do {
   try mystock.sold(amount: 8)
} catch {
   print(error)  // OutOfStock
}
